
markup.push({

	// -------------------------------------------------
	// MARK: low pass filter

	LowPassFilterBlock:
	{
		"+": "BlockTemplate",
		gxTitle: "Low Pass Filter",
		geNodeClass: "AHLowPassFilterNode",
		h4PresetsId: "LowPassFilterPresets",
		gxPopoverInfo: "LowPassFilterPopover",
		gxLibraryDescription: "Remove high frequency noise",
		gxLibraryIcon: "library.low.pass",
		geImporterParams: ["node.importCutoff"],
		gxChildViews:
		{
			cutoff: {
				"+": "SliderView.blockFace",
				gxValueKey: "node.cutoffFrequency",
				gxRangeMin: 50,
				gxRangeMax: 20000,
				gxKeystrokeStepSizeKeyPath: "node.stepSize",
				gxDefaultValue: 20000,
				axTitle: "Cutoff Frequency",
				axFormatter: "HertzFormatter",
			},
			label: {
				"+": "LabelView.foreColorTheme1.size11",
				gxFrameRect: "18,31,83,25",
				gxDefaultValue: "Cutoff",
			},
			readout: {
				"+": "LabelView.blockReadout",
				gxFrameRect: "18,66,83,25",
				gxValueKey: "node.cutoffFrequency",
				gxFormatter: "HertzFormatter"
			}
		}
	},

	// MARK: popover
	
	LowPassFilterPopover:
	{
		"+": "PopoverTemplate",
		gxTitle: "Low Pass Filter",
		axTitle: "De Click",
		gxCanDrawSubviewsIntoLayer: true,
		gxWantsLayer: true,
		gxLayout: [ "H:|-12-[self(284)]-12-|",	// sets popover width
					"V:|-12-[self]-12-|",
					"V:|-41-[group]-8-[presetsGroup]"
		],
		gxChildViews:
		{
			title: "PopoverTitle",
			switch: "PopoverOnOffSwitch",
			presetsGroup: presetsGroup(),
			group: {
				"+": "GroupView",
				gxLayout: [
					"H:|-0-[self]-0-|",
					"H:|-12-[cutoff]-12-|",
					"V:|-30-[cutoff]-16-|",

					"V:[cutoffLabel]-(-1)-[cutoff]&alignLeft",
					"V:[cutoffReadout]-(-1)-[cutoff]&alignRight",
				],
				gxChildViews: {
					cutoff: {
						"+": "SliderView",
						gxValueKey: "node.cutoffFrequency",
						gxRangeMin: 50,
						gxRangeMax: 20000,
						gxKeystrokeStepSizeKeyPath: "node.stepSize",
						gxDefaultValue: 20000,
						axTitle: "Cutoff Frequency",
						axFormatter: "HertzFormatter",
					},
					cutoffLabel: labelView("Cutoff Frequency"),
					cutoffReadout: {
						"+": "ReadoutView",
						gxValueKey: "node.cutoffFrequency",
						gxFormatter: "HertzFormatter"
					}
				}
			}
		}
	},


})
